<?php
session_start();
include 'conexao.php';

if (!isset($_SESSION['usuario'])) {
    header("Location: login.php");
    exit;
}

// Busca todos os usuários
$usuarios = $conn->query("SELECT id, nome, perfil FROM usuarios ORDER BY nome ASC")->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Enviar Documento</title>
  <style>
    body { font-family: Arial; padding: 20px; background: #f5f5f5; }
    form { background: white; padding: 20px; border-radius: 10px; width: 500px; margin: auto; box-shadow: 0 0 10px #ccc; }
    label { font-weight: bold; display: block; margin-top: 10px; }
    input, select { width: 100%; padding: 8px; margin-top: 5px; }
    button { margin-top: 15px; background: #007bff; color: white; border: none; padding: 10px 20px; border-radius: 6px; cursor: pointer; }
    button:hover { background: #0056b3; }
  </style>
</head>
<body>

<h2 style="text-align:center;">Enviar Documento Interno</h2>

<form action="enviar_documento.php" method="post" enctype="multipart/form-data">
  <label>Destinatário:</label>
  <select name="destinatario_id" required>
    <option value="">-- Escolha o destinatário --</option>
    <?php foreach ($usuarios as $u): ?>
      <option value="<?= $u['id'] ?>">
        <?= htmlspecialchars($u['nome']) ?> - <?= strtoupper($u['perfil']) ?>
      </option>
    <?php endforeach; ?>
  </select>

  <label>Título do Documento:</label>
  <input type="text" name="titulo" required>

  <label>Anexar Arquivo:</label>
  <input type="file" name="arquivo" accept=".pdf,.doc,.docx,.jpg,.png" required>

  <button type="submit">Enviar Documento</button>
</form>

</body>
</html>
